cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"
global distance 150

foreach type in tmax tmin tavg {
	global type `type'
	use "pair_trend_results $type $distance.dta", clear

	sort pair_id

	replace coef = 0.3 if coef > 0.3
	replace coef = -0.3 if coef < -0.3
	
	kdensity coef if adjustments == "raw", generate(raw_est raw_density) nograph
	kdensity coef if adjustments == "adj", generate(adj_est adj_density) nograph
		
	#delimit ;
		twoway 
		(line raw_density raw_est, lcolor(blue) lwidth(medium))
		(line adj_density adj_est, lcolor(red) lwidth(medium))
		,
		ytitle("Probability Density", size(medsmall))
		xtitle("Trend Difference (Deg. C/yr)", size(medsmall))
		xlabel(-0.3(0.1)0.3,labsize(medium))
		ylabel(0(5)20, gmax glcolor(black) glpattern(dot) labsize(medium)) 
		graphregion(color(white) lcolor(ebg))
		xline(0, lcolor(black) lpattern(shortdash))
		legend(region(fcolor(white) lcolor(white)) size(small) position(12) label(1 "USHCN Raw")  label(2 "USHCN Adjusted") order(1 2) col(2))
		saving(density_$type, replace)
		plotregion( m(b=0) )
		;
	#delimit cr
	*graph export "CRN HCN Pair Density $type $distance.png", replace width(1000)


	#delimit ;
	twoway 
		(scatter coef distance if adjustments == "raw", mcolor(blue) msize(vsmall))
		(scatter coef distance if adjustments == "adj", mcolor(red) msize(vsmall))
		,
		title("$type", size(large))
		ytitle("Trend Difference (Deg. C/yr)", size(medsmall))
		xtitle("Distance from CRN Station (Miles)", size(medsmall))
		xlabel(0(25)150,labsize(medium))
		ylabel(-0.3(0.1)0.3, gmax glcolor(black) glpattern(dot) labsize(medium)) 
		yline(0, lcolor(black) lpattern(shortdash))
		graphregion(color(white) lcolor(ebg))
		legend(off)
		saving(scatter_$type, replace)
		;
	#delimit cr
	*graph export "CRN HCN Pair Diff Distance $type $distance.png", replace width(1000)

}


grc1leg scatter_tmax.gph scatter_tmin.gph scatter_tavg.gph  density_tmax.gph density_tmin.gph density_tavg.gph, cols(3) row(2) position(6) legendfrom(density_tmax.gph) graphregion(fcolor(white)) imargin(0 0 0 0) name(g3, replace)

graph display g3, xsize(13) ysize(8)


cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/Images/"
graph export "CRN HCN Pairs $distance.png", replace width(1000)

